#ifndef _DIALOGS_MAIN_H
#define _DIALOGS_MAIN_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ServerDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        gbIsServerDialogOpen = true;

        ServerDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1002, "www.NetWorkDLS.com");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        SDI.Menu_hWnd = LoadMenu(MainInstance, MAKEINTRESOURCE(IDR_SERVERDLGMENU));
        SetMenu(xHandle, SDI.Menu_hWnd);

        SDI.ServerList_hWnd  = GetDlgItem(xHandle, IDC_SERVERLIST);

        RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(SDI.ServerList_hWnd, 0, 0, WindowRECT.right, WindowRECT.bottom, TRUE);

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(SDI.ServerList_hWnd, 0, 0, nWidth, nHeight, TRUE);
        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_SERVER_START)
        {
            StartServer();
            return TRUE;
        }

        if(wParam == ID_SERVER_STOP)
        {
            StopServer();
            return TRUE;
        }

        if(wParam == ID_SERVER_CLOSE)
        {
            gbIsServerDialogOpen = false;
            EndDialog(xHandle,0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        if(wParam == ID_SERVER_SETTINGS)
        {
            PROPSHEETPAGE   psp[4];
            PROPSHEETHEADER psh;

            memset(&psp[0], '\0', sizeof(PROPSHEETPAGE));
            psp[0].dwSize      = sizeof(PROPSHEETPAGE);
            psp[0].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[0].hInstance   = MainInstance;
            psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENERALTAB);
            psp[0].pszIcon     = NULL;
            psp[0].pszTitle    = "General";
            psp[0].pfnDlgProc  = TabGeneralDialog;
            psp[0].lParam      = 0;
            psp[0].pfnCallback = NULL;
            psp[0].pcRefParent = NULL;

            memset(&psp[1], '\0', sizeof(PROPSHEETPAGE));
            psp[1].dwSize      = sizeof(PROPSHEETPAGE);
            psp[1].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[1].hInstance   = MainInstance;
            psp[1].pszTemplate = MAKEINTRESOURCE(IDD_ACCOUNTSTAB);
            psp[1].pszIcon     = NULL;
            psp[1].pszTitle    = "User Accounts";
            psp[1].pfnDlgProc  = TabAccountsDialog;
            psp[1].lParam      = 0;
            psp[1].pfnCallback = NULL;
            psp[1].pcRefParent = NULL;

            memset(&psp[2], '\0', sizeof(PROPSHEETPAGE));
            psp[2].dwSize      = sizeof(PROPSHEETPAGE);
            psp[2].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[2].hInstance   = MainInstance;
            psp[2].pszTemplate = MAKEINTRESOURCE(IDD_SECURITYTAB);
            psp[2].pszIcon     = NULL;
            psp[2].pszTitle    = "Security";
            psp[2].pfnDlgProc  = TabSecurityDialog;
            psp[2].lParam      = 0;
            psp[2].pfnCallback = NULL;
            psp[2].pcRefParent = NULL;

            memset(&psp[3], '\0', sizeof(PROPSHEETPAGE));
            psp[3].dwSize      = sizeof(PROPSHEETPAGE);
            psp[3].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[3].hInstance   = MainInstance;
            psp[3].pszTemplate = MAKEINTRESOURCE(IDD_ADVANCEDTAB);
            psp[3].pszIcon     = NULL;
            psp[3].pszTitle    = "Advanced";
            psp[3].pfnDlgProc  = TabAdvancedDialog;
            psp[3].lParam      = 0;
            psp[3].pfnCallback = NULL;
            psp[3].pcRefParent = NULL;

            memset(&psh, '\0', sizeof(PROPSHEETHEADER));
            psh.dwSize      = sizeof(PROPSHEETHEADER);
            psh.dwFlags     = PSH_USEHICON | PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
            psh.hwndParent  = xHandle;
            psh.hInstance   = MainInstance;
            psh.hIcon       = LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAINICON));
            psh.pszCaption  = "Server Settings";
            psh.nPages      = 4;
            psh.nStartPage  = 0;
            psh.ppsp        = (LPCPROPSHEETPAGE) &psp;
            psh.pfnCallback = NULL;

            PropertySheet(&psh);

            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            NetLogo(xHandle);
            return TRUE;
        }

        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s", TitleCaption, FileVersion);
            MessageBox(xHandle, VersionText, "Application Version", MB_TASKMODAL);
            return TRUE;
        }

        if(LOWORD(wParam) == 1002) //- www.NetWorkDLS.com (SysMenu Command)
        {
            ShellExecute(0,"Open", "Http://www.NetWorkDLS.com", NULL, NULL, SW_SHOWNORMAL);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        gbIsServerDialogOpen = false;
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

